/*
* Copyright (C) 2008  Intel Corporation
*
* This library is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License, version 2.1, as published by the Free Software Foundation.
*
* This library is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* Lesser General Public License for more details.
*
* You should have received a copy of the GNU Lesser General Public
* License along with this library; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
*/

#include <stdio.h>             
#include <stdlib.h> 
#include <stddef.h>
#include <string.h> 
#include <signal.h> 
#include "DCSApi.h"
#include "PMApi.h"

void DCS_ReturnValue_handler(int ret)
{
	switch (ret)
	{
	case DCS_SUCCESS :
		printf("success\n");
		break;
	case DCS_NOT_SUPPORTED :
		printf("request is not supported\n");
		break;
	case DCS_REQUEST_DENIED:
		printf("request is denied\n");
		break;
	case DCS_MODULE_NOTEXIST:
		printf("request module does not exit\n");
		break;
	case DCS_EVENT_NOTEXIST:
		printf("request event does not exit\n");
		break;
	case DCS_FUNC_NOTEXIST:
		printf("request function does not exit\n");
		break;
	case DCS_FAIL_OPERATION:
		printf("operation failed\n");
		break;
	case DCS_CONNECTION_ABORT:
		printf("connection abort\n");
	default:
		break;
	}
}

int main(int argc, char *argv[])
{
	int ret = 0;
	int i=0;
	int use_pm=0;
	int enable_lan=0;
	int set_lanspeed=0;
	char c0;

	/* Command line parsing */
	for (i=1; i< argc; i++) 
	{
		if (strcmp("-enablelan", argv[i]) == 0 && i < argc - 1 ) {
			i++;
			enable_lan= atoi(argv[i]);
			printf("enable_lan=%d\n",enable_lan);
		}  else if (strcmp("-lanspeed", argv[i]) == 0 && i < argc - 1 ) {
			i++;
			set_lanspeed = atoi(argv[i]);
			printf("set_lanspeed=%d\n",set_lanspeed);
		}
	}

	/*initialize the DCS*/
	ret = DCS_Initialize();
	DCS_ReturnValue_handler(ret);

	BOOL enablelan;
	

	ret=DCS_SetLANStatus(enable_lan);
	DCS_ReturnValue_handler(ret);

	printf("*** Set LAN %d,please wait 3 seconds, and press any key to continue\n",enable_lan);
	scanf("%c",&c0);

	ret=DCS_GetLANStatus(&enablelan);
	DCS_ReturnValue_handler(ret);

	printf(" lan is set as: %d and the get the lan status :%d\n", enable_lan, enablelan);
	printf("*** press any key to continue\n");
	scanf("%c",&c0);

	if(enable_lan==1)
	{
		DCS_Lan_Speed  lanspeed;
		switch (set_lanspeed)
		{
		case 0:
			ret=DCS_SetLANSpeed(DCS_LAN_SPEED_10M_HALF_DUPLEX);
			DCS_ReturnValue_handler(ret);
			printf("*** Set LAN speed 10M_HALF_DUPLEX, please wait 3 seconds, and press any key to continue\n");
			scanf("%c",&c0);

			ret=DCS_GetLANSpeed(&lanspeed);
			DCS_ReturnValue_handler(ret);

			printf(" Lan speed is set as DCS_LAN_SPEED_10M_HALF_DUPLEX and get the Lan speed is:%d\n", lanspeed);

			break;
		case 1:
			ret=DCS_SetLANSpeed(DCS_LAN_SPEED_10M_FULL_DUPLEX);
			DCS_ReturnValue_handler(ret);
			printf("*** Set LAN speed 10M_FULL_DUPLEX, please wait 3 seconds, and press any key to continue\n");
			scanf("%c",&c0);

			ret=DCS_GetLANSpeed(&lanspeed);
			DCS_ReturnValue_handler(ret);

			printf(" Lan speed is set as DCS_LAN_SPEED_10M_FULL_DUPLEX and get the Lan speed is:%d\n", lanspeed);
			printf("\n");
			
			break;
		case 2:
			ret=DCS_SetLANSpeed(DCS_LAN_SPEED_100M_HALF_DUPLEX);
			DCS_ReturnValue_handler(ret);
			printf("*** Set LAN speed 100M_HALF_DUPLEX, please wait 3 seconds, and press any key to continue\n");
			scanf("%c",&c0);

			ret=DCS_GetLANSpeed(&lanspeed);
			DCS_ReturnValue_handler(ret);

			printf(" Lan speed is set as DCS_LAN_SPEED_100M_HALF_DUPLEX and get the Lan speed is:%d\n", lanspeed);
			
			break;
		case 3:
			ret=DCS_SetLANSpeed(DCS_LAN_SPEED_100M_FULL_DUPLEX);
			DCS_ReturnValue_handler(ret);
			printf("*** Set LAN speed 100M_FULL_DUPLEX, please wait 3 seconds, and press any key to continue\n");
			scanf("%c",&c0);

			ret=DCS_GetLANSpeed(&lanspeed);
			DCS_ReturnValue_handler(ret);

			printf(" Lan speed is set as DCS_LAN_SPEED_100M_FULL_DUPLEX and get the Lan speed is:%d\n", lanspeed);
			
			break;
		case 4:
			ret=DCS_SetLANSpeed(DCS_LAN_SPEED_1000M_AUTO_NEGOTIATE);
			DCS_ReturnValue_handler(ret);
			printf("*** Set LAN Speed AUTO_NEGOTIATE, please wait 3 seconds, and press any key to continue\n");
			scanf("%c",&c0);

			ret=DCS_GetLANSpeed(&lanspeed);
			DCS_ReturnValue_handler(ret);

			printf(" Lan speed is set as DCS_LAN_SPEED_1000M_AUTO_NEGOTIATE and get the Lan speed is:%d\n", lanspeed);
			
			break;
		default:
			break;
		}
	}

	/*uninitialize the DCS*/
	ret=DCS_Uninitialize();
	DCS_ReturnValue_handler(ret);

	return 0;
}

